﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UIElements;

public class MovingCube : MonoBehaviour
{
    [SerializeField]
    private Manager _manager;

    Vector3 acceleration = Vector3.zero;
    private Vector3 startPosition;

    private Rigidbody _rigidbody;

    void Start()
    {
        startPosition = transform.position;
        _rigidbody = GetComponent<Rigidbody>();
    }

    void FixedUpdate()
    {
        if (_manager.getFrozen() == false)
        {
            _rigidbody.constraints = RigidbodyConstraints.None;

            if (Input.GetKey(KeyCode.Q))
            {
                acceleration.x -= 2f;
            }
            if (Input.GetKey(KeyCode.D))
            {
                acceleration.x += 2f;
            }
            if (Input.GetKey(KeyCode.S))
            {
                acceleration.z -= 2f;
            }
            if (Input.GetKey(KeyCode.Z))
            {
                acceleration.z += 2f;
            }
            if (Input.GetKeyDown(KeyCode.Space))
            {
                acceleration.y += 1f;
            }
            acceleration *= 0.8f;

            if (_rigidbody.velocity.magnitude > 100.0f)
            {
                _rigidbody.velocity = 100.0f * _rigidbody.velocity.normalized;
            }
            _rigidbody.AddForce(100.0f * acceleration, ForceMode.Force);
        }
        else
        {
            _rigidbody.constraints = RigidbodyConstraints.FreezeAll;
        }

        if (transform.position.y < -1f)
        {
            transform.position = startPosition;
            _rigidbody.velocity = Vector3.zero;
        }
    }

}
